LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
ENTITY mux IS
  PORT (I0, I1, I2, I3, A, B : IN std_logic;
        Q : OUT std_logic);
END mux;

ARCHITECTURE mux_behave OF mux IS
  SIGNAL sel : INTEGER RANGE 0 TO 3;
BEGIN
  P1 : PROCESS(A, B, I0, I1, I2, I3)
  BEGIN

    sel <= 0;
    IF (A = '1') THEN sel <= sel + 1; END IF;
    IF (B = '1') THEN sel <= sel + 2; END IF;

    CASE sel IS
      WHEN 0 =>
        Q <= I0;
      WHEN 1 =>
        Q <= I1;
      WHEN 2 =>
        Q <= I2;
      WHEN 3 =>
        Q <= I3;
    END CASE;
  END PROCESS;
END mux_behave; 




ARCHITECTURE mux_fix1 OF mux IS
  SIGNAL sel : INTEGER RANGE 0 TO 3;
BEGIN
  PROCESS
  BEGIN
    sel <= 0;
    WAIT FOR 0 ns;  -- or wait on sel

    IF (a = '1') THEN sel <= sel + 1; END IF;
    WAIT for 0 ns;

    IF (b = '1') THEN sel <= sel + 2; END IF;
    WAIT FOR 0 ns;

    CASE sel IS
      WHEN 0 =>
        Q <= I0;
      WHEN 1 =>
        Q <= I1;
      WHEN 2 =>
        Q <= I2;
      WHEN 3 =>
        Q <= I3;
    END CASE;

    WAIT ON A, B, I0, I1, I2, I3;
  END PROCESS;
END mux_fix1; 





ARCHITECTURE mux_fix2 OF mux IS
BEGIN
  PROCESS(A, B, I0, I1, I2, I3)
    VARIABLE sel : INTEGER RANGE 0 TO 3;
  BEGIN
    sel := 0;
    IF (A = '1') THEN sel := sel + 1; END IF;
    IF (B = '1') THEN sel := sel + 2; END IF;

    CASE sel IS
      WHEN 0 =>
        Q <= I0;
      WHEN 1 =>
        Q <= I1;
      WHEN 2 =>
        Q <= I2;
      WHEN 3 =>
        Q <= I3;
    END CASE;
  END PROCESS;
END mux_fix2; 

